/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.entity.mutant;

import com.mojang.serialization.DynamicOps;
import fuzs.mutantmonsters.init.ModRegistry;
import fuzs.mutantmonsters.init.ModSoundEvents;
import fuzs.mutantmonsters.util.EntityUtil;
import fuzs.mutantmonsters.world.entity.AdditionalSpawnDataEntity;
import fuzs.mutantmonsters.world.entity.AnimatedEntity;
import fuzs.mutantmonsters.world.entity.EntityAnimation;
import fuzs.mutantmonsters.world.entity.ai.goal.AnimationGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.AvoidDamageGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.HurtByNearestTargetGoal;
import fuzs.mutantmonsters.world.entity.ai.goal.MutantMeleeAttackGoal;
import fuzs.mutantmonsters.world.entity.mutant.AbstractMutantMonster;
import fuzs.mutantmonsters.world.level.SeismicWave;
import fuzs.mutantmonsters.world.level.ZombieResurrection;
import fuzs.puzzleslib.api.entity.v1.DamageSourcesHelper;
import fuzs.puzzleslib.api.item.v2.ItemHelper;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1267;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1368;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1400;
import net.minecraft.class_1439;
import net.minecraft.class_1528;
import net.minecraft.class_1641;
import net.minecraft.class_1642;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3231;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3468;
import net.minecraft.class_3489;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_3988;
import net.minecraft.class_4135;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5712;
import net.minecraft.class_6880;

public class MutantZombie
extends AbstractMutantMonster
implements AnimatedEntity {
    public static final int MAX_VANISH_TIME = 100;
    public static final int MAX_DEATH_TIME = 140;
    public static final EntityAnimation SLAM_GROUND_ANIMATION = new EntityAnimation(25);
    public static final EntityAnimation THROW_ANIMATION = new EntityAnimation(15);
    public static final EntityAnimation ROAR_ANIMATION = new EntityAnimation(120);
    private static final class_2940<Integer> LIVES = class_2945.method_12791(MutantZombie.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Byte> THROW_ATTACK_STATE = class_2945.method_12791(MutantZombie.class, (class_2941)class_2943.field_13319);
    private static final EntityAnimation[] ANIMATIONS = new EntityAnimation[]{SLAM_GROUND_ANIMATION, THROW_ANIMATION, ROAR_ANIMATION};
    private final List<SeismicWave> seismicWaveList;
    private final List<ZombieResurrection> resurrectionList;
    public int throwHitTick = -1;
    public int throwFinishTick = -1;
    public int vanishTime;
    private EntityAnimation animation = EntityAnimation.NONE;
    private int animationTick;
    private class_1282 deathCause;

    public MutantZombie(class_1299<? extends MutantZombie> type, class_1937 worldIn) {
        super(type, worldIn);
        this.seismicWaveList = new ArrayList<SeismicWave>();
        this.resurrectionList = new ArrayList<ZombieResurrection>();
        this.field_6194 = 30;
    }

    public static class_5132.class_5133 registerAttributes() {
        return MutantZombie.method_26918().method_26868(class_5134.field_23716, 150.0).method_26868(class_5134.field_23721, 12.0).method_26868(class_5134.field_23717, 35.0).method_26868(class_5134.field_23719, 0.26).method_26868(class_5134.field_23718, 1.0).method_26868(class_5134.field_47761, 1.0);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new SlamGroundGoal(this));
        this.field_6201.method_6277(0, (class_1352)new RoarGoal(this));
        this.field_6201.method_6277(0, (class_1352)new ThrowAttackGoal(this));
        this.field_6201.method_6277(1, (class_1352)new MutantMeleeAttackGoal((class_1314)this, 1.2).setMaxAttackTick(0));
        this.field_6201.method_6277(2, (class_1352)new AvoidDamageGoal((class_1314)this, 1.0));
        this.field_6201.method_6277(3, (class_1352)new class_1368((class_1314)this, 1.0, true, 4, () -> false));
        this.field_6201.method_6277(4, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(5, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(6, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(0, (class_1352)new HurtByNearestTargetGoal((class_1314)this, class_1528.class).method_6318(new Class[0]));
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, class_1439.class, true));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, true).method_6330(300));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_3988.class, true));
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(LIVES, (Object)3);
        builder.method_56912(THROW_ATTACK_STATE, (Object)0);
    }

    public int getRemainingLives() {
        return (Integer)this.field_6011.method_12789(LIVES);
    }

    private void setRemainingLives(int lives) {
        this.field_6011.method_12778(LIVES, (Object)lives);
    }

    public boolean hasThrowAttackHit() {
        return ((Byte)this.field_6011.method_12789(THROW_ATTACK_STATE) & 1) != 0;
    }

    private void setThrowAttackHit(boolean hit) {
        byte b0 = (Byte)this.field_6011.method_12789(THROW_ATTACK_STATE);
        this.field_6011.method_12778(THROW_ATTACK_STATE, (Object)(hit ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE)));
    }

    public boolean isThrowAttackFinished() {
        return ((Byte)this.field_6011.method_12789(THROW_ATTACK_STATE) & 2) != 0;
    }

    private void setThrowAttackFinished(boolean finished) {
        byte b0 = (Byte)this.field_6011.method_12789(THROW_ATTACK_STATE);
        this.field_6011.method_12778(THROW_ATTACK_STATE, (Object)(finished ? (byte)(b0 | 2) : (byte)(b0 & 0xFFFFFFFD)));
    }

    @Override
    public EntityAnimation getAnimation() {
        return this.animation;
    }

    @Override
    public void setAnimation(EntityAnimation animation) {
        this.animation = animation;
    }

    @Override
    public EntityAnimation[] getAnimations() {
        return ANIMATIONS;
    }

    @Override
    public int getAnimationTick() {
        return this.animationTick;
    }

    @Override
    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    protected float method_6031(float renderYawOffset, float distance) {
        return this.field_6213 > 0 ? distance : super.method_6031(renderYawOffset, distance);
    }

    public int method_5945() {
        return 1;
    }

    public int method_5850() {
        return this.method_5968() != null ? (int)this.method_5739((class_1297)this.method_5968()) : 3;
    }

    public class_1269 method_5664(class_1657 player, class_243 vec, class_1268 hand) {
        if (player.method_7325()) {
            return class_1269.field_5811;
        }
        class_1799 itemInHand = player.method_5998(hand);
        class_1799 itemInHandCopy = itemInHand.method_7972();
        class_1269 interactionResult = this.deadMobInteract(player, hand);
        if (interactionResult.method_23665()) {
            if (player.method_31549().field_7477 && itemInHand == player.method_5998(hand) && itemInHand.method_7947() < itemInHandCopy.method_7947()) {
                itemInHand.method_7939(itemInHandCopy.method_7947());
            }
            if (itemInHand.method_7960() && !player.method_31549().field_7477) {
                player.method_6122(hand, class_1799.field_8037);
            }
            this.method_32876((class_6880)class_5712.field_28725);
            return interactionResult;
        }
        return super.method_5664(player, vec, hand);
    }

    private class_1269 deadMobInteract(class_1657 player, class_1268 interactionHand) {
        class_1799 itemInHand = player.method_5998(interactionHand);
        if (itemInHand.method_31573(class_3489.field_41662) && !this.method_5805() && !this.method_5809() && !this.method_5721()) {
            this.method_37908().method_43128(player, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_15145, this.method_5634(), 1.0f, this.field_5974.method_43057() * 0.4f + 0.8f);
            if (!this.method_37908().field_9236) {
                this.method_5639(8.0f);
                if (!itemInHand.method_7963()) {
                    itemInHand.method_7934(1);
                } else {
                    ItemHelper.hurtAndBreak((class_1799)itemInHand, (int)1, (class_1309)player, (class_1268)interactionHand);
                }
                player.method_7259(class_3468.field_15372.method_14956((Object)itemInHand.method_7909()));
            }
            return class_1269.method_29236((boolean)this.method_37908().field_9236);
        }
        return class_1269.field_5811;
    }

    public void method_56073(int ticks) {
        super.method_56073(ticks);
        if (this.method_37908() instanceof class_3218 && this.method_29504()) {
            this.setRemainingLives(0);
        }
    }

    public boolean method_6121(class_1297 entityIn) {
        if (!this.isAnimationPlaying()) {
            if (entityIn.method_5854() != this && this.field_5974.method_43048(5) != 0) {
                if (this.method_24828() || !this.method_55667().method_26227().method_15769()) {
                    this.animation = SLAM_GROUND_ANIMATION;
                }
            } else {
                this.animation = THROW_ANIMATION;
            }
        }
        return true;
    }

    protected void method_5958() {
        if (!this.isAnimationPlaying() && this.method_5968() != null && Math.abs(this.method_23318() - this.method_5968().method_23318()) <= 1.0 && this.method_5858((class_1297)this.method_5968()) <= 49.0 && this.field_5974.method_43048(20) == 0) {
            this.animation = SLAM_GROUND_ANIMATION;
        }
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (this.method_5679(source)) {
            return false;
        }
        class_1297 entity = source.method_5529();
        return (entity == null || this.canHarm(entity) && (this.animation != THROW_ANIMATION || entity != this.method_5968())) && super.method_5643(source, amount);
    }

    protected void method_16827() {
    }

    public void method_5773() {
        super.method_5773();
        this.fixRotation();
        this.updateAnimation();
        this.updateMeleeGrounds();
        if (this.method_37908().method_23886() && this.field_6012 % 100 == 0 && this.method_5805() && this.method_6032() < this.method_6063()) {
            this.method_6025(2.0f);
        }
        for (int i = this.resurrectionList.size() - 1; i >= 0; --i) {
            ZombieResurrection zr = this.resurrectionList.get(i);
            if (zr.update(this)) continue;
            this.resurrectionList.remove((Object)zr);
        }
        if (this.method_6032() > 0.0f) {
            this.field_6213 = 0;
            this.vanishTime = 0;
        }
    }

    private void fixRotation() {
        float yaw;
        for (yaw = this.field_6241 - this.field_6283; yaw < -180.0f; yaw += 360.0f) {
        }
        while (yaw >= 180.0f) {
            yaw -= 360.0f;
        }
        float offset = 0.1f;
        if (this.animation == SLAM_GROUND_ANIMATION) {
            offset = 0.2f;
        }
        this.field_6283 += yaw * offset;
    }

    private void updateAnimation() {
        if (this.isAnimationPlaying()) {
            ++this.animationTick;
        }
        if (this.method_37908().field_9236) {
            if (this.animation == THROW_ANIMATION) {
                if (this.hasThrowAttackHit()) {
                    if (this.throwHitTick == -1) {
                        this.throwHitTick = 0;
                    }
                    ++this.throwHitTick;
                }
                if (this.isThrowAttackFinished()) {
                    if (this.throwFinishTick == -1) {
                        this.throwFinishTick = 0;
                    }
                    ++this.throwFinishTick;
                }
            } else {
                this.throwHitTick = -1;
                this.throwFinishTick = -1;
            }
        }
    }

    private void updateMeleeGrounds() {
        if (!this.seismicWaveList.isEmpty()) {
            SeismicWave wave = this.seismicWaveList.remove(0);
            wave.affectBlocks(this.method_37908(), (class_1297)this);
            class_238 box = new class_238((double)wave.method_10263(), (double)wave.method_10264() + 1.0, (double)wave.method_10260(), (double)wave.method_10263() + 1.0, (double)wave.method_10264() + 2.0, (double)wave.method_10260() + 1.0);
            if (wave.isFirst()) {
                double addScale = this.field_5974.method_43058() * 0.75;
                box = box.method_1009(0.25 + addScale, 0.25 + addScale * 0.5, 0.25 + addScale);
            }
            class_1282 source = DamageSourcesHelper.source((class_4538)this.method_37908(), ModRegistry.MUTANT_ZOMBIE_SEISMIC_WAVE_DAMAGE_TYPE, (class_1297)this);
            for (class_1297 entity : this.method_37908().method_8333((class_1297)this, box, class_1301.field_6156.and(this::canHarm))) {
                if (entity instanceof class_1309 && entity.method_5643(source, wave.isFirst() ? (float)(9 + this.field_5974.method_43048(4)) : (float)(6 + this.field_5974.method_43048(3))) && this.field_5974.method_43048(5) == 0) {
                    ((class_1309)entity).method_6092(new class_1293(class_1294.field_5903, 160, 1));
                }
                double x = entity.method_23317() - this.method_23317();
                double z = entity.method_23321() - this.method_23321();
                double d = Math.sqrt(x * x + z * z);
                entity.method_18800(x / d * 0.3, 0.04, z / d * 0.3);
                EntityUtil.sendPlayerVelocityPacket(entity);
            }
        }
    }

    public class_238 method_5830() {
        return this.method_5829().method_1014(1.0);
    }

    protected boolean method_5860(class_1297 entityIn) {
        return false;
    }

    public boolean method_5675() {
        return false;
    }

    protected void method_6060(class_1309 livingEntity) {
        livingEntity.field_6037 = true;
    }

    public void method_6078(class_1282 damageSource) {
        if (!this.method_37908().field_9236) {
            if (this.method_5809()) {
                this.setRemainingLives(0);
            }
            this.deathCause = damageSource;
            for (class_4135 goal : this.field_6201.method_35115()) {
                if (!goal.method_19056()) continue;
                goal.method_6270();
            }
            this.method_6114((class_1297)this.method_6065());
            this.method_37908().method_8421((class_1297)this, (byte)3);
            if (this.field_6238 > 0) {
                this.field_6238 += 140;
            }
        }
    }

    protected void method_6108() {
        if (this.getRemainingLives() > 0) {
            if (++this.field_6213 >= 140) {
                this.field_6213 = 0;
                this.deathCause = null;
                this.method_6033(this.method_6063() / 4.0f);
                this.setRemainingLives(this.getRemainingLives() - 1);
            }
        } else {
            if (this.field_6213 > 100) {
                --this.field_6213;
            } else if (this.field_6213 < 100) {
                ++this.field_6213;
            }
            if (++this.vanishTime >= 100) {
                class_1282 killedByDamageSource = this.deathCause;
                super.method_6078(killedByDamageSource != null ? killedByDamageSource : this.method_48923().method_48830());
                super.method_6108();
            }
        }
    }

    public void method_5711(byte id) {
        if (id == 60) {
            this.makePoofParticles();
        } else {
            super.method_5711(id);
        }
    }

    public void makePoofParticles() {
        for (int i = 0; i < 30; ++i) {
            double d0 = this.field_5974.method_43059() * 0.02;
            double d1 = this.field_5974.method_43059() * 0.02;
            double d2 = this.field_5974.method_43059() * 0.02;
            this.method_37908().method_8406((class_2394)(this.method_5809() ? class_2398.field_11240 : class_2398.field_11203), this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), d0, d1, d2);
        }
    }

    public void method_5768() {
        super.method_5768();
        this.setRemainingLives(0);
    }

    private boolean canHarm(class_1297 entity) {
        return entity.method_5864() != class_1299.field_6051 && entity.method_5864() != class_1299.field_6054 && entity.method_5864() != class_1299.field_6071 && entity.method_5864() != class_1299.field_6123 && !(entity instanceof MutantZombie);
    }

    public boolean method_5874(class_3218 level, class_1309 entity) {
        boolean bl = super.method_5874(level, entity);
        if ((level.method_8407() == class_1267.field_5802 || level.method_8407() == class_1267.field_5807) && entity instanceof class_1646) {
            class_1646 villager = (class_1646)entity;
            if (level.method_8407() != class_1267.field_5807 && this.field_5974.method_43056()) {
                return bl;
            }
            class_1641 zombieVillager = (class_1641)villager.method_29243(class_1299.field_6054, false);
            if (zombieVillager != null) {
                zombieVillager.method_5943((class_5425)level, level.method_8404(zombieVillager.method_24515()), class_3730.field_16468, (class_1315)new class_1642.class_1644(false, true));
                zombieVillager.method_7195(villager.method_7231());
                zombieVillager.method_21649((class_2520)villager.method_21651().method_19067((DynamicOps)class_2509.field_11560));
                zombieVillager.method_16916(villager.method_8264().method_53882());
                zombieVillager.method_19622(villager.method_19269());
                if (!this.method_5701()) {
                    level.method_8444(null, 1026, this.method_24515(), 0);
                }
                bl = false;
            }
        }
        return bl;
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10569("Lives", this.getRemainingLives());
        compound.method_10575("VanishTime", (short)this.vanishTime);
        if (!this.resurrectionList.isEmpty()) {
            class_2499 listnbt = new class_2499();
            for (ZombieResurrection resurrection : this.resurrectionList) {
                class_2487 compoundNBT = new class_2487();
                compoundNBT.method_10566("ResurrectionPosition", class_2512.method_10692((class_2338)resurrection));
                compoundNBT.method_10569("Tick", resurrection.getTick());
                listnbt.add((Object)compoundNBT);
            }
            compound.method_10566("Resurrections", (class_2520)listnbt);
        }
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        if (compound.method_10545("Lives")) {
            this.setRemainingLives(compound.method_10550("Lives"));
        }
        this.vanishTime = compound.method_10568("VanishTime");
        class_2499 listNBT = compound.method_10554("Resurrections", 10);
        for (int i = 0; i < listNBT.size(); ++i) {
            class_2487 compoundNBT = listNBT.method_10602(i);
            Optional optional = class_2512.method_10691((class_2487)compoundNBT, (String)"ResurrectionPosition");
            optional.ifPresent(blockPos -> this.resurrectionList.add(new ZombieResurrection((class_2338)blockPos, compoundNBT.method_10550("Tick"))));
        }
    }

    protected class_3414 method_5994() {
        return (class_3414)ModSoundEvents.ENTITY_MUTANT_ZOMBIE_AMBIENT_SOUND_EVENT.comp_349();
    }

    protected class_3414 method_6011(class_1282 damageSourceIn) {
        return (class_3414)ModSoundEvents.ENTITY_MUTANT_ZOMBIE_HURT_SOUND_EVENT.comp_349();
    }

    protected class_3414 method_6002() {
        return (class_3414)ModSoundEvents.ENTITY_MUTANT_ZOMBIE_DEATH_SOUND_EVENT.comp_349();
    }

    protected void method_5712(class_2338 pos, class_2680 blockIn) {
        if (this.field_6213 == 0) {
            this.method_5783(class_3417.field_14621, 0.15f, 1.0f);
        }
    }

    @Override
    public void writeAdditionalAddEntityData(class_2540 buffer) {
        AnimatedEntity.super.writeAdditionalAddEntityData(buffer);
        buffer.method_10804(this.field_6213);
        buffer.method_10804(this.vanishTime);
        buffer.method_10804(this.throwHitTick);
        buffer.method_10804(this.throwFinishTick);
    }

    @Override
    public void readAdditionalAddEntityData(class_2540 additionalData) {
        AnimatedEntity.super.readAdditionalAddEntityData(additionalData);
        this.field_6213 = additionalData.method_10816();
        this.vanishTime = additionalData.method_10816();
        this.throwHitTick = additionalData.method_10816();
        this.throwFinishTick = additionalData.method_10816();
    }

    public class_2596<class_2602> method_18002(class_3231 serverEntity) {
        return AdditionalSpawnDataEntity.getPacket(this, serverEntity);
    }

    static class SlamGroundGoal
    extends AnimationGoal<MutantZombie> {
        private double dirX = -1.0;
        private double dirZ = -1.0;

        public SlamGroundGoal(MutantZombie mob) {
            super(mob);
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406, class_1352.class_4134.field_18407));
        }

        @Override
        protected EntityAnimation getAnimation() {
            return SLAM_GROUND_ANIMATION;
        }

        @Override
        public boolean method_6264() {
            return ((MutantZombie)this.mob).method_5968() != null && super.method_6264();
        }

        @Override
        public void method_6269() {
            super.method_6269();
            ((MutantZombie)this.mob).field_6191 = -((MutantZombie)this.mob).method_5970();
            ((MutantZombie)this.mob).method_5783((class_3414)ModSoundEvents.ENTITY_MUTANT_ZOMBIE_ATTACK_SOUND_EVENT.comp_349(), 0.3f, 0.8f + ((MutantZombie)this.mob).field_5974.method_43057() * 0.4f);
        }

        public void method_6268() {
            class_1309 target = ((MutantZombie)this.mob).method_5968();
            if (target != null) {
                ((MutantZombie)this.mob).method_5942().method_6340();
                if (((MutantZombie)this.mob).animationTick < 8) {
                    ((MutantZombie)this.mob).field_6206.method_6226((class_1297)target, 30.0f, 30.0f);
                }
                if (((MutantZombie)this.mob).animationTick == 8) {
                    double x = target.method_23317() - ((MutantZombie)this.mob).method_23317();
                    double z = target.method_23321() - ((MutantZombie)this.mob).method_23321();
                    double d = Math.sqrt(x * x + z * z);
                    this.dirX = x / d;
                    this.dirZ = z / d;
                }
                if (((MutantZombie)this.mob).animationTick == 12) {
                    int x = class_3532.method_15357((double)(((MutantZombie)this.mob).method_23317() + this.dirX * 2.0));
                    int y = class_3532.method_15357((double)((MutantZombie)this.mob).method_5829().field_1322);
                    int z = class_3532.method_15357((double)(((MutantZombie)this.mob).method_23321() + this.dirZ * 2.0));
                    int x1 = class_3532.method_15357((double)(((MutantZombie)this.mob).method_23317() + this.dirX * 8.0));
                    int z1 = class_3532.method_15357((double)(((MutantZombie)this.mob).method_23321() + this.dirZ * 8.0));
                    SeismicWave.createWaves(((MutantZombie)this.mob).method_37908(), ((MutantZombie)this.mob).seismicWaveList, x, z, x1, z1, y);
                    ((MutantZombie)this.mob).method_5783((class_3414)class_3417.field_15152.comp_349(), 0.5f, 0.8f + ((MutantZombie)this.mob).field_5974.method_43057() * 0.4f);
                }
            }
        }

        @Override
        public void method_6270() {
            super.method_6270();
            this.dirX = -1.0;
            this.dirZ = -1.0;
        }
    }

    static class RoarGoal
    extends AnimationGoal<MutantZombie> {
        public RoarGoal(MutantZombie mob) {
            super(mob);
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406, class_1352.class_4134.field_18407));
        }

        @Override
        protected EntityAnimation getAnimation() {
            return ROAR_ANIMATION;
        }

        @Override
        public boolean method_6264() {
            return ((MutantZombie)this.mob).field_6012 % 3 == 0 && !((MutantZombie)this.mob).isAnimationPlaying() && ((MutantZombie)this.mob).method_5968() != null && ((MutantZombie)this.mob).method_24828() && ((MutantZombie)this.mob).resurrectionList.isEmpty() && ((MutantZombie)this.mob).method_5858((class_1297)((MutantZombie)this.mob).method_5968()) > 16.0 && ((MutantZombie)this.mob).field_5974.method_43057() * 100.0f < 0.35f;
        }

        @Override
        public void method_6269() {
            super.method_6269();
            ((MutantZombie)this.mob).field_6008 = 20;
            ((MutantZombie)this.mob).field_6191 = -((MutantZombie)this.mob).method_5970();
        }

        public void method_6268() {
            ((MutantZombie)this.mob).method_5942().method_6340();
            if (((MutantZombie)this.mob).animationTick < 75 && ((MutantZombie)this.mob).method_5968() != null) {
                ((MutantZombie)this.mob).field_6206.method_6226((class_1297)((MutantZombie)this.mob).method_5968(), 30.0f, 30.0f);
            }
            if (((MutantZombie)this.mob).animationTick == 10) {
                ((MutantZombie)this.mob).method_5783((class_3414)ModSoundEvents.ENTITY_MUTANT_ZOMBIE_ROAR_SOUND_EVENT.comp_349(), 3.0f, 0.7f + ((MutantZombie)this.mob).field_5974.method_43057() * 0.2f);
                for (class_1297 entity : ((MutantZombie)this.mob).method_37908().method_8333((class_1297)this.mob, ((MutantZombie)this.mob).method_5829().method_1009(12.0, 8.0, 12.0), class_1301.field_6156)) {
                    if (!((MutantZombie)this.mob).canHarm(entity) || !(((MutantZombie)this.mob).method_5858(entity) <= 196.0)) continue;
                    double x = entity.method_23317() - ((MutantZombie)this.mob).method_23317();
                    double z = entity.method_23321() - ((MutantZombie)this.mob).method_23321();
                    double d = Math.sqrt(x * x + z * z);
                    entity.method_18800(x / d * 0.7, 0.3, z / d * 0.7);
                    entity.method_5643(DamageSourcesHelper.source((class_4538)((MutantZombie)this.mob).method_37908(), ModRegistry.PIERCING_MOB_ATTACK_DAMAGE_TYPE, (class_1297)this.mob), (float)(2 + ((MutantZombie)this.mob).field_5974.method_43048(2)));
                    EntityUtil.sendPlayerVelocityPacket(entity);
                }
            }
            if (((MutantZombie)this.mob).animationTick >= 20 && ((MutantZombie)this.mob).animationTick < 80 && ((MutantZombie)this.mob).animationTick % 10 == 0) {
                int x = class_3532.method_15357((double)((MutantZombie)this.mob).method_23317());
                int y = class_3532.method_15357((double)((MutantZombie)this.mob).method_5829().field_1322);
                int z = class_3532.method_15357((double)((MutantZombie)this.mob).method_23321());
                y = ZombieResurrection.getSuitableGround(((MutantZombie)this.mob).method_37908(), x += (1 + ((MutantZombie)this.mob).field_5974.method_43048(8)) * (((MutantZombie)this.mob).field_5974.method_43056() ? 1 : -1), y - 1, z += (1 + ((MutantZombie)this.mob).field_5974.method_43048(8)) * (((MutantZombie)this.mob).field_5974.method_43056() ? 1 : -1));
                if (y != -1) {
                    ((MutantZombie)this.mob).resurrectionList.add(new ZombieResurrection(((MutantZombie)this.mob).method_37908(), x, y, z));
                }
            }
        }
    }

    static class ThrowAttackGoal
    extends AnimationGoal<MutantZombie> {
        private int finish = -1;

        public ThrowAttackGoal(MutantZombie mob) {
            super(mob);
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406, class_1352.class_4134.field_18407));
        }

        @Override
        protected EntityAnimation getAnimation() {
            return THROW_ANIMATION;
        }

        @Override
        public boolean method_6264() {
            return ((MutantZombie)this.mob).method_5968() != null && super.method_6264();
        }

        @Override
        public void method_6269() {
            super.method_6269();
            class_1309 target = ((MutantZombie)this.mob).method_5968();
            if (target != null) {
                target.method_5848();
                double x = target.method_23317() - ((MutantZombie)this.mob).method_23317();
                double z = target.method_23321() - ((MutantZombie)this.mob).method_23321();
                double d = Math.sqrt(x * x + z * z);
                target.method_18800(x / d * 0.8, 1.6, z / d * 0.8);
                EntityUtil.sendPlayerVelocityPacket((class_1297)target);
            }
        }

        @Override
        public boolean method_6266() {
            if (this.finish >= 10) {
                return false;
            }
            class_1309 target = ((MutantZombie)this.mob).method_5968();
            if (target == null) {
                return false;
            }
            if (!target.method_5805()) {
                return false;
            }
            return !(target instanceof class_1657) || !target.method_7325() && !((class_1657)target).method_7337();
        }

        public void method_6268() {
            class_1309 target = ((MutantZombie)this.mob).method_5968();
            if (target != null) {
                ((MutantZombie)this.mob).method_5942().method_6340();
                ((MutantZombie)this.mob).field_6206.method_6226((class_1297)target, 30.0f, 30.0f);
                if (((MutantZombie)this.mob).animationTick == THROW_ANIMATION.duration()) {
                    ((MutantZombie)this.mob).field_17046 = class_243.field_1353;
                    double d1 = target.method_23317() - ((MutantZombie)this.mob).method_23317();
                    double d2 = target.method_23318() - ((MutantZombie)this.mob).method_23318();
                    double x = target.method_23321() - ((MutantZombie)this.mob).method_23321();
                    double z = Math.sqrt(d1 * d1 + d2 * d2 + x * x);
                    ((MutantZombie)this.mob).method_18800(d1 / z * 3.4, d2 / z * 1.4, x / z * 3.4);
                } else if (((MutantZombie)this.mob).animationTick > THROW_ANIMATION.duration()) {
                    double d1 = ((MutantZombie)this.mob).method_17681() * 2.0f * ((MutantZombie)this.mob).method_17681() * 2.0f;
                    double d2 = ((MutantZombie)this.mob).method_5649(target.method_23317(), target.method_5829().field_1322, target.method_23321());
                    if (d2 < d1 && !((MutantZombie)this.mob).hasThrowAttackHit()) {
                        ((MutantZombie)this.mob).setThrowAttackHit(true);
                        if (!target.method_5643(((MutantZombie)this.mob).method_37908().method_48963().method_48812((class_1309)this.mob), (float)((MutantZombie)this.mob).method_45325(class_5134.field_23721))) {
                            EntityUtil.disableShield(target, 150);
                        }
                        double x = target.method_23317() - ((MutantZombie)this.mob).method_23317();
                        double z = target.method_23321() - ((MutantZombie)this.mob).method_23321();
                        double d = Math.sqrt(x * x + z * z);
                        target.method_18800(x / d * 0.6, -1.2, z / d * 0.6);
                        target.field_6008 = 10;
                        EntityUtil.sendPlayerVelocityPacket((class_1297)target);
                        EntityUtil.stunRavager(target);
                        ((MutantZombie)this.mob).method_5783((class_3414)ModSoundEvents.ENTITY_MUTANT_ZOMBIE_GRUNT_SOUND_EVENT.comp_349(), 0.3f, 0.8f + ((MutantZombie)this.mob).field_5974.method_43057() * 0.4f);
                    }
                    if (!(!((MutantZombie)this.mob).method_24828() && ((MutantZombie)this.mob).method_55667().method_26227().method_15769() || ((MutantZombie)this.mob).isThrowAttackFinished())) {
                        this.finish = 0;
                        ((MutantZombie)this.mob).setThrowAttackFinished(true);
                    }
                    if (this.finish >= 0) {
                        ++this.finish;
                    }
                }
            }
        }

        @Override
        public void method_6270() {
            super.method_6270();
            this.finish = -1;
            ((MutantZombie)this.mob).setThrowAttackHit(false);
            ((MutantZombie)this.mob).setThrowAttackFinished(false);
        }
    }
}

